<?php
use Bitrix\Main\Localization\Loc;
Loc::loadMessages(__FILE__);

$data = array(
    'NAME' => Loc::getMessage('GATELINE_MODULE_TITLE'),
    'SORT' => 100,
    'CODES' => array(
        'GATELINE_UID' => array(
            'NAME' => Loc::getMessage('GATELINE_UID_NAME'),
            'SORT' => 100,
            'GROUP' => Loc::getMessage('GATELINE_GROUP_GATE'),
        ),
        'GATELINE_PASSWD' => array(
            'NAME' => Loc::getMessage('GATELINE_PASSWD_NAME'),
            'SORT' => 110,
            'GROUP' => Loc::getMessage('GATELINE_GROUP_GATE'),
        ),
        'GATELINE_SANDBOX' => array(
            'NAME' => Loc::getMessage('GATELINE_SANDBOX_NAME'),
            'SORT' => 120,
            'GROUP' => Loc::getMessage('GATELINE_GROUP_GATE'),
            'INPUT' => array(
                'TYPE' => 'Y/N',
            ),
            'DEFAULT' => array(
                'PROVIDER_VALUE' => 'N',
                'PROVIDER_KEY' => 'INPUT',
            ),
        ),
        'GATELINE_FISCALIZATION' => array(
            'NAME' => Loc::getMessage('GATELINE_FISCALIZATION_NAME'),
            'SORT' => 130,
            'GROUP' => Loc::getMessage('GATELINE_GROUP_GATE'),
            'INPUT' => array(
                'TYPE' => 'Y/N',
            ),
            'DEFAULT' => array(
                'PROVIDER_VALUE' => 'N',
                'PROVIDER_KEY' => 'INPUT',
            ),
        ),
        'GATELINE_INN' => array(
            'NAME' => Loc::getMessage('GATELINE_INN_NAME'),
            'SORT' => 140,
            'GROUP' => Loc::getMessage('GATELINE_GROUP_GATE'),
        ),
        'GATELINE_GROUP' => array(
            'NAME' => Loc::getMessage('GATELINE_GROUP_NAME'),
            'SORT' => 150,
            'GROUP' => Loc::getMessage('GATELINE_GROUP_GATE'),
        ),
        'GATELINE_TYPE' => array(
            'NAME' => Loc::getMessage('GATELINE_TYPE_NAME'),
            'SORT' => 160,
            'GROUP' => Loc::getMessage('GATELINE_GROUP_GATE'),
            'INPUT' => array(
                'TYPE' => 'ENUM',
                'OPTIONS' => array(),
            )
        ),
        'GATELINE_TAX' => array(
            'NAME' => Loc::getMessage('GATELINE_TAX_NAME'),
            'SORT' => 170,
            'GROUP' => Loc::getMessage('GATELINE_GROUP_GATE'),
            'INPUT' => array(
                'TYPE' => 'ENUM',
                'OPTIONS' => array(),           
            ),
        ),
        'GATELINE_PAYMENTMETHODTYPE' => array(
            'NAME' => Loc::getMessage('GATELINE_PAYMENTMETHODTYPE_NAME'),
            'SORT' => 180,
            'GROUP' => Loc::getMessage('GATELINE_GROUP_GATE'),
            'INPUT' => array(
                'TYPE' => 'ENUM',
                'OPTIONS' => array(),
            ),
        ),
        'GATELINE_PAYMENTSUBJECTTYPE' => array(
            'NAME' => Loc::getMessage('GATELINE_PAYMENTSUBJECTTYPE_NAME'),
            'SORT' => 190,
            'GROUP' => Loc::getMessage('GATELINE_GROUP_GATE'),
            'INPUT' => array(
                'TYPE' => 'ENUM',
                'OPTIONS' => array(),
            ),
        ),
        'GATELINE_AGENTTYPE' => array(
            'NAME' => Loc::getMessage('GATELINE_AGENTTYPE_NAME'),
            'SORT' => 200,
            'GROUP' => Loc::getMessage('GATELINE_GROUP_GATE'),
            'INPUT' => array(
                'TYPE' => 'ENUM',
                'OPTIONS' => array(),
            ),
        ),        
        'GATELINE_TAXATIONSYSTEM' => array(
            'NAME' => Loc::getMessage('GATELINE_TAXATIONSYSTEM_NAME'),
            'SORT' => 210,
            'GROUP' => Loc::getMessage('GATELINE_GROUP_GATE'),
            'INPUT' => array(
                'TYPE' => 'ENUM',
                'OPTIONS' => array(),
            ),
        ),
        'GATELINE_PAYMENTTYPE' => array(
            'NAME' => Loc::getMessage('GATELINE_PAYMENTTYPE_NAME'),
            'SORT' => 220,
            'GROUP' => Loc::getMessage('GATELINE_GROUP_GATE'),
            'INPUT' => array(
                'TYPE' => 'ENUM',
                'OPTIONS' => array(),
            ),
        ),
    ),
);

const LANGUAGE_OPTIONS_LIST = [
    'TYPE'                => '1-4',
    'TAX'                 => '1-6',
    'PAYMENTMETHODTYPE'   => '1-7',
    'PAYMENTSUBJECTTYPE'  => '1-26',
    'AGENTTYPE'           => '0-6',
    'TAXATIONSYSTEM'      => '0-5',
    'PAYMENTTYPE'         => [1,2,14,15,16]
];

foreach (LANGUAGE_OPTIONS_LIST as $key => $value) {
    $method_data = array();

    if (gettype($value) == 'array') {
        foreach ($value as $num) {
            $data['CODES']['GATELINE_'.$key]['INPUT']['OPTIONS'][$num + 100] = 
                Loc::getMessage('GATELINE_'.$key.'_'.$num);
        }
    } else {
        $borders = explode('-', $value);

        for ($num = $borders[0]; $num <= $borders[1]; $num++) {
            $data['CODES']['GATELINE_'.$key]['INPUT']['OPTIONS'][$num + 100] = 
                Loc::getMessage('GATELINE_'.$key.'_'.$num);
        }
    }
}
