<?
$pathInstall = str_replace('\\', '/', __FILE__);
$pathInstall = substr($pathInstall, 0, strlen($pathInstall) - strlen('/index.php'));

IncludeModuleLangFile($pathInstall . '/install.php');

class gateline_payment extends CModule
{
    var $MODULE_ID = 'gateline.payment';
    var $MODULE_VERSION;
    var $MODULE_VERSION_DATE;
    var $MODULE_NAME;
    var $MODULE_DESCRIPTION;

    function gateline_payment()
    {
        $arModuleVersion = array();
        include($this->path().'/version.php');
        if (is_array($arModuleVersion) && array_key_exists('VERSION', $arModuleVersion)) {
            $this->MODULE_VERSION = $arModuleVersion['VERSION'];
            $this->MODULE_VERSION_DATE = $arModuleVersion['VERSION_DATE'];
        }

        $this->MODULE_NAME = GetMessage('GATELINE_MODULE_NAME');
        $this->MODULE_DESCRIPTION = GetMessage('GATELINE_MODULE_DESCRIPTION');

        $this->PARTNER_NAME = GetMessage('DEVELOPER');
        $this->PARTNER_URI = GetMessage('DEVELOPER_SITE');
    }

    private function path()
    {
        $path = str_replace("\\", "/", __FILE__);
        $path = substr($path, 0, strlen($path) - strlen('/index.php'));
        return $path;
    }

    function DoInstall()
    {
        $this->InstallFiles();
        RegisterModule($this->MODULE_ID);
        return true;
    }

    function InstallFiles()
    {
        $this->copy_dir(
            '/bitrix/modules/'.$this->MODULE_ID.'/install/payment',
            '/bitrix/php_interface/include/sale_payment/',
        );
        $this->copy_dir(
            '/bitrix/modules/'.$this->MODULE_ID.'/install/images',
            '/bitrix/images/sale/sale_payments/',
        );

        return true;
    }

    private function copy_dir($src, $dest = '')
    {
        $root = $_SERVER['DOCUMENT_ROOT'];
        CopyDirFiles($root.$src, $root.$dest, true, true);
    }

    function DoUninstall()
    {
        $this->UnInstallFiles();
        COption::RemoveOption($this->MODULE_ID);
        UnRegisterModule($this->MODULE_ID);
        return true;
    }

    function UnInstallFiles($arParams = array())
    {
        DeleteDirFilesEx('/bitrix/php_interface/include/sale_payment/gateline_payment');
        DeleteDirFilesEx('/bitrix/images/sale/sale_payments/gateline_payment.png');
        return true;
    }
}

?>
