<?php

class ControllerExtensionPaymentGateline extends Controller
{
    const LANGUAGE_LIST = [
        'heading_title',
        'text_edit',
        'text_enabled',
        'text_disabled',
        'entry_status',
        'entry_uid',
        'entry_passwd',
        'entry_sandbox',
        'entry_result_url',
        'entry_order_status',
        'entry_order_status_failed',
        'entry_order_status_pending',
        'entry_sort_order',
        'button_save',
        'button_cancel',
        'tab_general',
    ];

    const SETTING_LIST = [
        'gateline_status',
        'gateline_uid',
        'gateline_passwd',
        'gateline_sandbox',
        'gateline_order_status_id',
        'gateline_order_status_failed_id',
        'gateline_order_status_pending_id',
        'gateline_sort_order',
    ];

    const REQUIRED_SETTING_LIST = [
        'gateline_uid',
        'gateline_passwd',
    ];

    private $error = [];

    public function index()
    {
        $this->load->language('extension/payment/gateline');
        $this->document->setTitle($this->language->get('heading_title'));

        if ($this->request->server['REQUEST_METHOD'] == 'POST' && $this->validate()) {

            $this->load->model('setting/setting');
            $this->model_setting_setting->editSetting('gateline', $this->request->post);
            $this->session->data['success'] = $this->language->get('text_success');

            return $this->response->redirect($this->url->link('extension/extension', 'token=' . $this->session->data['token'] . '&type=payment', 'SSL'));
        }

        foreach (self::LANGUAGE_LIST as $key) {
            $data[$key] = $this->language->get($key);
        }

        foreach ($this->error as $key => $val) {
            $data['error_' . $key] = $val;
        }

        foreach (self::SETTING_LIST as $key) {
            $data[$key] = $this->get_param($key);
        }

        $data['gateline_result_url'] = HTTP_CATALOG . 'index.php?route=extension/payment/gateline/result_payment';

        $this->load->model('localisation/order_status');
        $data['order_statuses'] = $this->model_localisation_order_status->getOrderStatuses();

        $data['header'] = $this->load->controller('common/header');
        $data['column_left'] = $this->load->controller('common/column_left');
        $data['footer'] = $this->load->controller('common/footer');

        $data['breadcrumbs'] = $this->get_breadcrumbs();
        $data['action'] = $this->get_link('extension/payment/gateline');
        $data['cancel'] = $this->get_link('extension/extension');

        $this->response->setOutput($this->load->view('extension/payment/gateline', $data));
    }

    private function validate()
    {
        if (!$this->user->hasPermission('modify', 'extension/payment/gateline')) {
            $this->error['warning'] = $this->language->get('error_permission');
        }

        foreach (self::REQUIRED_SETTING_LIST as $key) {
            if (empty($this->request->post[$key])) {
                $this->error[$key] = $this->language->get('error_' . $key);
            }
        }

        return !$this->error;
    }

    private function get_param($key)
    {
        if (isset($this->request->post[$key])) return $this->request->post[$key];
        return $this->config->get($key);
    }

    private function get_link($path)
    {
        return $this->url->link($path, 'token=' . $this->session->data['token'], 'SSL');
    }

    private function get_breadcrumbs()
    {
        return [
            [
                'text' => $this->language->get('text_home'),
                'href' => $this->get_link('common/dashboard'),
            ],
            [
                'text' => $this->language->get('text_payment'),
                'href' => $this->get_link('extension/extension'),
            ],
            [
                'text' => $this->language->get('heading_title'),
                'href' => $this->get_link('extension/payment/gateline'),
            ],
        ];
    }
}

?>
