<?php

class ControllerExtensionPaymentGateline extends Controller
{
    private function get_url()
    {
        if ($this->config->get('gateline_sandbox')) {
            return 'https://simpleapi.sandbox.gateline.ru:18610/pay';
        }
        return 'https://simpleapi.gateline.ru/pay';
    }

    public function index()
    {
        $this->load->language('extension/payment/gateline');

        $order_id = $this->session->data['order_id'];
        $this->load->model('checkout/order');
        $order = $this->model_checkout_order->getOrder($order_id);

        $data = [
            'site' => trim($this->config->get('gateline_uid')),
            'merchant_order_id' => $order_id,
            'amount' => number_format($order['total'], 2, '.', ''),
            'description' => 'Order #'.$order_id,
            'email' => trim($order['email']),
        ];
        $data['checksum'] = $this->calc_checksum($data);
        $data['action'] = $this->get_url();
        $data['button_confirm'] = $this->language->get('button_confirm');

        $this->cart->clear();

        return $this->load->view('extension/payment/gateline', $data);
    }

    public function result_payment()
    {
        $this->load->language('extension/payment/gateline');

        $data['heading_title'] = $this->language->get('heading_title');
        $data['heading_subtitle'] = $this->language->get('heading_subtitle');
        $data['message'] = $this->process_payment();

        $data['header'] = $this->load->controller('common/header');
        $data['column_left'] = $this->load->controller('common/column_left');
        $data['column_right'] = $this->load->controller('common/column_right');
        $data['content_top'] = $this->load->controller('common/content_top');
        $data['content_bottom'] = $this->load->controller('common/content_bottom');
        $data['footer'] = $this->load->controller('common/footer');

        $template = 'extension/payment/gateline_result';
        $this->response->setOutput($this->load->view($template, $data));
    }

    private function process_payment()
    {
        $params = $_GET;
        if (!$this->is_checksum_valid($params)) {
            return 'Wrong checksum';
        }

        $order_id = $params['merchant_order_id'];
        $this->load->model('checkout/order');
        $order = $this->model_checkout_order->getOrder($order_id);
        if (!$order) {
            return 'Order not found';
        }

        $order_status_id = null;
        $msg = $params['message'];
        if ($msg) $msg .= '<br />';
        if ($params['status'] == 'success') {
            $order_status_id = $this->config->get('gateline_order_status_id');
            $msg .= $this->language->get('payment_result_success');
        }
        elseif ($params['status'] == 'failed') {
            $order_status_id = $this->config->get('gateline_order_status_failed_id');
            $msg .= $this->language->get('payment_result_failure');
        }
        else {
            $msg .= $this->language->get('payment_result_error');
        }

        if ($order_status_id) {
            $this->model_checkout_order->addOrderHistory($order_id, $order_status_id);
        }
        return $msg;
    }

    public function callback()
    {
        ob_start();

        $params = $this->request->request;
        if (!$this->is_checksum_valid($params)) {
            return $this->result_error('Wrong checksum');
        }

        $order_id = $params['merchant_order_id'];
        $this->load->model('checkout/order');
        $order = $this->model_checkout_order->getOrder($order_id);
        if (!$order) {
            return $this->result_error('Order not found');
        }

        $order_status_id = null;
        if ($params['status'] == 'success') {
            $order_status_id = $this->config->get('gateline_order_status_id');
        }
        elseif ($params['status'] == 'failed') {
            $order_status_id = $this->config->get('gateline_order_status_failed_id');
        }

        if ($order_status_id) {
            $this->model_checkout_order->addOrderHistory($order_id, $order_status_id);
        }
        return $this->result_success();
    }

    private function result_success()
    {
        ob_end_clean();
        header('HTTP/1.0 200 OK');
        echo 'OK';
        exit();
    }

    private function result_error($msg)
    {
        ob_end_flush();
        die($msg);
    }

    private function calc_checksum($query)
    {
        unset($query['checksum']);
        ksort($query);

        $kv = [];
        foreach ($query as $key => $value) {
            $kv[] = $key . '=' . $value;
        }
        $content = implode(';', $kv);

        return hash_hmac('sha1', $content, trim($this->config->get('gateline_passwd')));
    }

    private function is_checksum_valid($request)
    {
        $sum = $request['checksum'];
        return ($this->calc_checksum($request) == $sum);
    }
}

?>
