<?php
defined('_JEXEC') or die('Restricted access');

class pm_gateline extends PaymentRoot
{

    function showPaymentForm($params, $pmconfigs)
    {
        include(dirname(__FILE__) . "/paymentform.php");
    }

    function showAdminFormParams($params)
    {
        $array_params = array('preference', 'transaction_end_status', 'transaction_pending_status', 'transaction_failed_status');
        foreach ($array_params as $key) {
            if (!isset($params[$key]))
                $params[$key] = '';
        }
        $orders = JSFactory::getModel('orders', 'JshoppingModel');
        include(dirname(__FILE__) . "/adminparamsform.php");
    }

    function checkTransaction($params, $order, $act){
        saveToLog("payment.log","t1: ".$params['secret_key']);
        saveToLog("payment.log","t2: ".$pmconfigs['secret_key']);
        $posted = JRequest::get();
        if (!array_key_exists ('merchant_order_id', $posted) || !isset($posted['merchant_order_id'])) {
            return array(0,'error merchant_order_id');
        }
        $order_id = $posted['merchant_order_id'];
        if(!$order_id) {
            return array(0,'error order_id');
        }

        $message = "act=".$posted['act'].";";
        if (isset($posted['code'])) { $message .= "code=".$posted['code'].";"; }
        $message .= "controller=".$posted['controller'].";";
        $message .= "js_paymentclass=".$posted['js_paymentclass'].";";
        if (isset($posted['merchant_order_id'])) { $message .= "merchant_order_id=".$posted['merchant_order_id'].";"; }
        $message .= "message=".$posted['message'].";";
        $message .= "option=".$posted['option'].";";
        if (isset($posted['order_id'])) { $message .= "order_id=".$posted['order_id'].";"; }
        $message .= "status=".$posted['status'].";";
        $message .= "task=".$posted['task'];
        $signature = hash_hmac('sha1', $message, $params['secret_key']);

        $checksum = $posted['checksum'];
        if ($checksum == $signature)
        {
            // echo 'OK';
            // header("Location: component/jshopping/checkout/finish?Itemid=0"); /* Redirect browser */
            return array(1, $order_id);
            // exit();
        } else {
            return array(0,'Incorrect request sign');
        }
    }

    function showEndForm($pmconfigs, $order)
    {
        $description = sprintf(_JSHOP_PAYMENT_NUMBER, $order->order_number);
        $amount = number_format(floatval($order->order_total), 2, '.', '');
        $url = $pmconfigs['api_url'];
        $message = "amount=".$amount.";description=".$description.";email=".$order->email.";merchant_order_id=".$order->order_id.";site=".$pmconfigs['eshop_id'];
        $signature = hash_hmac('sha1', $message, $pmconfigs['secret_key']);
        // htmlspecialchars($)
        $args = array(
            'amount'    => $amount,
            'description'   =>  $description,
            'email' =>  $order->email,
            'merchant_order_id' =>  $order->order_id,
            'site'  =>  $pmconfigs['eshop_id'],
            'checksum'  =>  $signature
            );
        $args_array = array();

        foreach ($args as $key => $value) {
            $args_array[] = '<input type="hidden" name="' . $key . '" value="' . $value . '" />';
        }
        ?>
        <html>
        <head>
            <meta http-equiv="content-type" content="text/html; charset=utf-8"/>
        </head>
        <body>
            <form id="paymentform" action="<?php echo $url; ?>" name="paymentform" method="post">
                <?php echo implode("\n", $args_array); ?>
            </form>
            <?php print _JSHOP_REDIRECT_TO_PAYMENT_PAGE ?>
            <script type="text/javascript">document.getElementById('paymentform').submit();</script>
        </body>
        </html>
        <?php
        die();
    }

    function getUrlParams($pmconfigs)
    {
        $params = array();
        $params['order_id'] = JRequest::getInt("merchant_order_id");
        $params['hash'] = "";
        $params['checkHash'] = 0;
        $params['checkReturnParams'] = 1;
        return $params;
    }
}

?>