<?php

class ControllerExtensionPaymentGateline extends Controller {

    private $error = array();

    const LANGUAGE_LIST = [
        'heading_title',
        'text_edit',
        'entry_eshopid',
        'entry_secret_key',
        'entry_link',
        'entry_initialization_password',
        'entry_result_url',
        'text_enabled',
        'text_disabled',
        'text_all_zones',
        'entry_order_status_pending',
        'entry_order_status',
        'entry_order_status_failed',
        'entry_geo_zone',
        'entry_status',
        'entry_sort_order',
        'button_save',
        'button_cancel',
        'tab_general',
        'text_fiscalization',
        'text_inn',
        'text_group'
    ];
    
    const LANGUAGE_OPTIONS_LIST = [
        'entry_type'                => '1-4',
        'entry_tax'                 => '1-6',
        'entry_paymentmethodtype'   => '1-7',
        'entry_paymentsubjecttype'  => '1-26',
        'entry_agenttype'           => '0-6',
        'entry_taxationsystem'      => '0-5',
        'entry_paymenttype'         => [1,2,14,15,16]
    ];

    const PARAMS_LIST = [
        'payment_gateline_fiscalization',
        'payment_gateline_inn',
        'payment_gateline_group',
        'payment_gateline_type',
        'payment_gateline_tax',
        'payment_gateline_paymentmethodtype',
        'payment_gateline_paymentsubjecttype',
        'payment_gateline_agenttype',
        'payment_gateline_taxationsystem',
        'payment_gateline_paymenttype',
        'payment_gateline_eshopid',
        'payment_gateline_link',
        'payment_gateline_initialization_password',
        'payment_gateline_order_status_pending_id',
        'payment_gateline_order_status_id',
        'payment_gateline_order_status_failed_id',
        'gateline_geo_zone_id',
        'payment_gateline_status',
        'payment_gateline_sort_order'
    ];

    public function index() {
        $this->load->model('extension/payment/gateline');
        $this->load->language('extension/payment/gateline');

        if (method_exists($this->document, 'setTitle'))
            $this->document->setTitle($this->language->get('heading_title'));
        else
            $this->document->title = $this->language->get('heading_title');

        $this->load->model('setting/setting');

        if (($this->request->server['REQUEST_METHOD'] == 'POST') && ($this->validate())) {
            
            $this->model_setting_setting->editSetting('payment_gateline', $this->request->post);
            $this->session->data['success'] = $this->language->get('text_success');

            $this->response->redirect($this->url->link('marketplace/extension', 'user_token=' . $this->session->data['user_token'] . '&type=payment', true)); 
        }

        foreach (self::LANGUAGE_LIST as $key) {
            $data[$key] = $this->language->get($key);
        }

        foreach (self::LANGUAGE_OPTIONS_LIST as $key => $value) {
            $data[$key] = $this->language->get($key);
           
            $names = explode('_', $key);
            
            $method_data = array();
            if (gettype($value) == 'array') {
                foreach ($value as $num) {
                    $data[$key.'_'.$num] = $this->language->get($key.'_'.$num);
                    array_push($method_data, ['id' => $num, 'name' => $this->language->get($key.'_'.$num)]);
                }
            } else {
                $borders = explode('-', $value);

                for ($num = $borders[0]; $num <= $borders[1]; $num++) {
                    $data[$key.'_'.$num] = $this->language->get($key.'_'.$num);
                    array_push($method_data, ['id' => $num, 'name' => $this->language->get($key.'_'.$num)]);
                }
            }

            $names[1] = preg_replace('/$/', 's', $names[1]);
            $names[1] = preg_replace('/xs$/', 'xes', $names[1]);

            $data[$names[1]] = $method_data;
        }

        foreach (self::PARAMS_LIST as $key) {
            if (isset($this->request->post[$key])) {
                $data[$key] = $this->request->post[$key];
            } else {
                $data[$key] = $this->config->get($key);
            }
        }

        if (isset($this->error['warning'])) {
            $data['error_warning'] = $this->error['warning'];
        } else {
            $data['error_warning'] = '';
        }

        if (isset($this->error['error_eshop_id'])) {
            $data['error_eshop_id'] = $this->error['error_eshop_id'];
        } else {
            $data['error_eshop_id'] = '';
        }

        if (isset($this->error['secret_key'])) {
            $data['error_secret_key'] = $this->error['secret_key'];
        } else {
            $data['error_secret_key'] = '';
        }
  
        $data['breadcrumbs'] = array();

        $data['breadcrumbs'][] = array(
            'text' => $this->language->get('text_home'),
            'href' => $this->url->link('common/dashboard', 'user_token=' . $this->session->data['user_token'], true)
        );

        $data['breadcrumbs'][] = array(
            'text' => $this->language->get('text_payment'),
            'href' => $this->url->link('marketplace/extension', 'user_token=' . $this->session->data['user_token'], true)
        );

        $data['breadcrumbs'][] = array(
            'text' => $this->language->get('heading_title'),
            'href' => $this->url->link('extension/payment/gateline', 'user_token=' . $this->session->data['user_token'], true)
        );

        $data['action'] = $this->url->link('extension/payment/gateline', 'user_token=' . $this->session->data['user_token'], true);
        $data['cancel'] = $this->url->link('marketplace/extension', 'user_token=' . $this->session->data['user_token'], true);

        // URL
        $data['payment_gateline_result_url'] = HTTP_CATALOG . 'index.php?route=extension/payment/gateline/result_payment?';

        $this->load->model('localisation/order_status');

        $data['order_statuses'] = $this->model_localisation_order_status->getOrderStatuses();

        $this->load->model('localisation/geo_zone');
        $data['geo_zones'] = $this->model_localisation_geo_zone->getGeoZones();

        $data['header'] = $this->load->controller('common/header');
        $data['column_left'] = $this->load->controller('common/column_left');
        $data['footer'] = $this->load->controller('common/footer');

        $this->response->setOutput($this->load->view('extension/payment/gateline', $data));
    }

    private function validate() {
        if (!$this->user->hasPermission('modify', 'extension/payment/gateline')) {
            $this->error['warning'] = $this->language->get('error_permission');
        }

        if (!$this->request->post['payment_gateline_eshopid']) {
            $this->error['error_eshop_id'] = $this->language->get('error_eshop_id');
        }

        if (!$this->error) {
            return TRUE;
        } else {
            return FALSE;
        }
    }

}

?>
