<?php

class ControllerExtensionPaymentGateline extends Controller {

    function ob_exit($status = null) {
        if ($status) {
            ob_end_flush();
            isset($_REQUEST['debug']) ? exit($status) : exit();
        } else {
            ob_end_clean();
            header("HTTP/1.0 200 OK");
            echo "OK";
            exit();
        }
    }

    function debug_file() {
        header('Content-type: text/plain; charset=utf-8');
        echo file_get_contents(__FILE__);
    }

    function check_im() {
        $iplist = gethostbynamel('gateline.net');
        foreach ($iplist as $ip)
            if (preg_match("/^$ip/", (isset($_SERVER['HTTP_REFERER'])) ? $_SERVER['HTTP_REFERER'] : ''))
                return true;
        return false;
    }

    function from_request($name) {
        return isset($this->request->request[$name]) ? html_entity_decode($this->request->request[$name]) : null;
    }

    function generateReceipt() {
        $this->load->model('checkout/order');
        $order_info = $this->model_checkout_order->getOrder($this->session->data['order_id']);

        $positions = array();
        $payments = array();

        foreach ($this->cart->getProducts() as $product) {
            array_push($positions, 
                [
                    'Quantity'              => $product['quantity'],
                    'Text'                  => $product['name'],
                    'Price'                 => $product['price'],
                    'PaymentMethodType'     => $this->config->get('payment_gateline_paymentmethodtype'),
                    'PaymentSubjectType'    => $this->config->get('payment_gateline_paymentsubjecttype'),
                    'Tax'                   => $this->config->get('payment_gateline_tax')
                ]);
            array_push($payments, 
                [
                    'Type'      => $this->config->get('payment_gateline_paymenttype'),
                    'Amount'    => $product['quantity'] * $product['price']
                ]);
        }

        $json = array();

        array_push($json, ['electronic_receipt' => 
            [
                'Id'        => $this->session->data['order_id'],
                'INN'       => $this->config->get('payment_gateline_inn'),
                'Group'     => $this->config->get('payment_gateline_group'),
                'Content'   => [
                    'Type'              => $this->config->get('payment_gateline_type'),
                    'CustomerContact'   => $order_info['email'],
                    'Positions'         => $positions,
                    'CheckClose'     => [
                        'Payments'          => $payments,
                        'TaxationSystem'    => $this->config->get('payment_gateline_taxationsystem')
                    ]
                ]
            ]
        ]);
        return json_encode($json[0]);
    }

    function var_error_log( $object=null ){
        ob_start();                    // start buffer capture
        var_dump( $object );           // dump the values
        $contents = ob_get_contents(); // put the buffer into a variable
        ob_end_clean();                // end capture
        //error_log( $contents );      // log contents of the result of var_dump( $object )
        return $contents;
    }

    public function index() {
        $this->load->language('extension/payment/gateline');

        $data['button_confirm'] = $this->language->get('button_confirm');
        $data['button_back']    = $this->language->get('button_back');

        $this->load->model('checkout/order');
        $order_info = $this->model_checkout_order->getOrder($this->session->data['order_id']);

        $amount   = number_format($order_info['total'], 2, '.', '');
        $idShop   = $this->config->get('payment_gateline_eshopid');
        $idOrder  = $this->session->data['order_id'];
        $desc     = 'Заказ '.$idOrder;
        $initPass = $this->config->get('payment_gateline_initialization_password');
        $email    = $order_info['email'];

        $message  = '';
        $receipt  = '';
        $extended = '';
        
        if ($this->config->get('payment_gateline_fiscalization')) {
            $receipt = $this->generateReceipt();
            //$this->log->write($receipt);
            $extended = ';extended='.$receipt;
        }       

        $message =
              'amount='             .$amount
            .';description='        .$desc
            .';email='              .$email
                                    .$extended
            .';merchant_order_id='  .$idOrder
            .';site='               .$idShop;

        $checksum = hash_hmac('sha1', $message, $initPass);

        $data['amount']             = $amount;
        $data['site']               = $idShop;
        $data['merchant_order_id']  = $idOrder;
        $data['email']              = $email;
        $data['checksum']           = $checksum;
        $data['description']        = $desc;
        $data['action']             = $this->config->get('payment_gateline_link');

        if ($this->config->get('payment_gateline_fiscalization')) {
            $data['extended'] = $receipt;
        } else {
            $data['extended'] = false;
        }

        $this->cart->clear();
        return $this->load->view('extension/payment/gateline', $data);
    }
    
    public function result_payment()
    {
        $this->load->language('extension/payment/gateline');

        $data['heading_title'] = $this->language->get('heading_title');
        $data['heading_subtitle'] = $this->language->get('heading_subtitle');
        $data['message'] = $this->process_payment();

        $data['header'] = $this->load->controller('common/header');
        $data['column_left'] = $this->load->controller('common/column_left');
        $data['column_right'] = $this->load->controller('common/column_right');
        $data['content_top'] = $this->load->controller('common/content_top');
        $data['content_bottom'] = $this->load->controller('common/content_bottom');
        $data['footer'] = $this->load->controller('common/footer');

        $template = 'extension/payment/gateline_result';
        $this->response->setOutput($this->load->view($template, $data));
    }

    private function process_payment()
    {
        $params = $_GET;
        if (!$this->is_checksum_valid($params)) {
            return 'Wrong checksum';
        }

        $order_id = $params['merchant_order_id'];
        $this->load->model('checkout/order');
        $order = $this->model_checkout_order->getOrder($order_id);
        if (!$order) {
            return 'Order not found';
        }

        $order_status_id = null;
        $msg = $params['message'];
        if ($msg) $msg .= '<br />';
        if ($params['status'] == 'success') {
            $order_status_id = $this->config->get('payment_gateline_order_status_id');
            $msg .= $this->language->get('payment_result_success');
        }
        elseif ($params['status'] == 'failed') {
            $order_status_id = $this->config->get('payment_gateline_order_status_failed_id');
            $msg .= $this->language->get('payment_result_failure');
        }
        else {
            $msg .= $this->language->get('payment_result_error');
        }

        if ($order_status_id) {
            $this->model_checkout_order->addOrderHistory($order_id, $order_status_id);
        }
        return $msg;
    }

    private function calc_checksum($query)
    {
        unset($query['checksum']);
        ksort($query);

        $kv = [];
        foreach ($query as $key => $value) {
            $kv[] = $key . '=' . $value;
        }
        $content = implode(';', $kv);

        return hash_hmac('sha1', $content, trim($this->config->get('payment_gateline_initialization_password')));
    }

    private function is_checksum_valid($request)
    {
        $sum = $request['checksum'];
        return ($this->calc_checksum($request) == $sum);
    }    
}
?>