<?php

class gatelinePayment extends waPayment implements waIPayment
{

    /**
     * Генерирует HTML-код формы оплаты.
     * @param waOrder $order_data Объект, содержащий всю доступную информацию о заказе
     * @param bool $auto_submit Флаг, обозначающий, должна ли платежная форма автоматически отправить данные без участия пользователя
     *     (удобно при оформлении заказа)
     * @throws waException
     */
    public function payment($payment_form_data, $order_data, $auto_submit = true)
    {
        // заполняем обязательный элемент данных с описанием заказа
        /*if (empty($order_data['description'])) {
            $order_data['description'] = 'Заказ '.$order_data['order_id'];
        }*/

        // вызываем класс-обертку, чтобы гарантировать использование данных в правильном формате
        $order = waOrder::factory($order_data);

        // добавляем в платежную форму поля, требуемые ПШ Gateline
        $siteName = $this->GL_SITE_UID;
        $toSend = array(
            'amount' => number_format($order->total, 2, '.', ''),
            'description' => ($order->description),
            'merchant_order_id' => ltrim(($order->order_id_str),"\#"),
            'site' => $siteName,
        );

        $site_key= $this->GL_SITE_PASSWORD;
        $goto = '';
        foreach ($toSend as $key => $value) {
          $goto .= $key . "=" . $value . ";";
        }
        $goto = rtrim($goto, ';');
        $hash = hash_hmac('sha1', $goto, $site_key);
        $toSend['checksum'] = $hash;
        $view = wa()->getView();

        $view->assign('url', wa()->getRootUrl());
        $view->assign('toSend', $toSend);
        $view->assign('auto_submit', $auto_submit);

        // переход на платежную форму GL
        if ($this->TESTMODE) {
          //тестовая среда
          return $view->fetch($this->path.'/templates/simpleapiSand.html');
        } else {
          //боевая среда
          return $view->fetch($this->path.'/templates/simpleapiProd.html');
        }

    }

    public function allowedCurrency()
   {
       return 'RUB';
   }

    protected function callbackInit($request)
    {
        return parent::callbackInit($request);
    }

    protected function callbackHandler($request)
    {
      return array(
          'message' => 'YES',
      );
    }

    private function getReceiptData(waOrder $order)
    {

    }

    private function formatItem($item)
    {

    }

}
